//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2

import wesual.Controls 1.0
import wesual.data.Core 1.0

Rectangle {
    id : delegate

    property Document   document                : modelData // from model
    property alias      selectionLeftMargin     : selection.leftMargin
    property alias      selectionRightMargin    : selection.rightMargin
    property alias      selectionWidth          : selection.width

    readonly property int  itemIndex            : index
    readonly property bool active               : view.activeIndex === index
    readonly property bool scrollHandleVisible  : view ? view.willScroll : false
    readonly property bool mousePressed         : mouseArea.pressed

    width  : view ? view.width : 200
    height : 30

    readonly property Item view : {
        if (ListView && ListView.view) {
            return ListView.view;
        }
        throw new Error("Failed to obtain the containing view");
    }

    Rectangle {
        id : selection
        property int leftMargin : 0
        property int rightMargin : 0

        anchors.fill : parent
        anchors.rightMargin : /*scrollHandleVisible ? 3+rightMargin : */rightMargin
        anchors.leftMargin : leftMargin
        color : {
            if (!active)
                return UI.color(UI.PrimaryBase);

            if (mouseArea.pressed) {
                return UI.color(UI.PrimaryPress);
            } else {
                return UI.color(UI.PrimaryHover);
            }
        }
        Behavior on color {
            ColorAnimation {
                duration : 0
            }
        }
    }

    MouseArea {
        id : mouseArea
        anchors.fill : parent
        acceptedButtons : Qt.LeftButton
        hoverEnabled : true
        onPositionChanged : view.activeIndex = delegate.itemIndex;
        onReleased : view.accept(delegate.itemIndex);
        onClicked :  view.accept(delegate.itemIndex);
    }
}
